/* ------------------------------------------------------------------------ */
/*   Title     : DEMOCD.C                             *** TC Version ***    */
/*                                                                          */
/*   Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.  */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <bios.h>
#include "sbcd.h"


unsigned char BCD2Binary( unsigned char ) ;
unsigned long HSG2RED( unsigned long ) ;
void Display( void ) ;


main( )
{
    unsigned    skip_sec = 16 ;
    char        ch ;
    int         wKey, quit=0 ;
    int         drv_num ;


    if( !sbcd_init( &drv_num ) )       /* initialization */
    {
        Display() ;

        while( quit == 0 )
        {
            ShowInfo() ;

            if ( bioskey(1) )
            {
                if ( (wKey=bioskey(0)) & 0xff )
                {
                    ch = toupper(wKey & 255) ;

                    switch( ch )
                    {
                        case 'P' :                      /* play first track */
                            sbcd_play( 1, 0, 0xffff ) ; /* till the end */
                            break ;

                        case 'S' :                      /* stop */
                            sbcd_stop() ;
                            break ;

                        case 'A' :                      /* pause */
                            sbcd_pause() ;
                            break ;

                        case 'C' :                      /* continue */
                            sbcd_continue() ;
                            break ;

                        case 'N' :                      /* next track */
                            sbcd_next_track() ;
                            break ;

                        case 'L' :                      /* previous track */
                            sbcd_prev_track() ;
                            break ;

                        case 'F' :                      /* fast forward 16 sec */
                            sbcd_fastforward( skip_sec ) ;
                            break ;

                        case 'R' :                      /* rewind 16 sec */
                            sbcd_rewind( skip_sec ) ;
                            break ;

                        case 'Q' :                      /* quit */
                            quit = 1 ;
                    }
                }
            }
        }
    }
    else
        printf( "Initialization error" ) ;
}


void Display( void )
{
    printf( "\n\n\nCompact Disc Player Demo Program\n\n" ) ;
    printf( "\tP  : Play\n" ) ;
    printf( "\tS  : Stop\n" ) ;
    printf( "\tA  : Pause\n" ) ;
    printf( "\tC  : Continue\n" ) ;
    printf( "\tN  : Next Track\n" ) ;
    printf( "\tL  : Previous Track\n" ) ;
    printf( "\tF  : Fast Forward\n" ) ;
    printf( "\tR  : Rewind\n" ) ;
    printf( "\tQ  : Quit\n\n" ) ;
}


ShowInfo()
{
    QCHAN_INFO      qch_info ;
    unsigned long   volume ;


    sbcd_get_loc_info( &qch_info ) ;
    sbcd_get_volume( &volume ) ;
    volume = HSG2RED( volume ) ;

    printf( "Disc - %02d:%02d, Track - %02d %02d:%02d, Vol - %02d:%02d\r",
            qch_info.pmin, qch_info.psec,
            BCD2Binary(qch_info.tno),
            qch_info.min,  qch_info.sec,
            LOBYTE(HIWORD(volume)), HIBYTE(LOWORD(volume)) ) ;
}


/* Conversion from BCD to binary. */

unsigned char BCD2Binary( unsigned char data )
{
    unsigned char   ret_val ;


    ret_val = ( data >> 4 )*10 + ( data & 0xf ) ;

    return( ret_val ) ;
}


/* Conversion from High Sierra format to Red Book format */

unsigned long HSG2RED( unsigned long data )
{
    unsigned long   v0, v1, v2 ;


    v2 = data / 4500 ;              /* 4500 = 60 * 75 */
    v1 = ( data % 4500 ) / 75 ;
    v0 = ( data % 4500 ) % 75 ;

    return( ( v2 << 16 ) | ( v1 << 8 ) | v0 ) ;
}
